; Define RC5 address of Remote Control    
RemoteAddr  EQU	0x00

; Definition of Keys and key-codes on my remote control

NUM_0	EQU	0x00
NUM_1	EQU	0x01
NUM_2	EQU	0x02
NUM_3	EQU	0x03
NUM_4	EQU	0x04
NUM_5	EQU	0x05
NUM_6	EQU	0x06
NUM_7	EQU	0x07
NUM_8	EQU	0x08
NUM_9	EQU	0x09
FREEZE	EQU	0x5D
PAUSE	EQU	0x30
STANDBY	EQU	0x0C
MUTE	EQU	0x0D
HELP	EQU	0x2F
TEXT	EQU	0x0F
VOL_UP	EQU	0x10
VOL_DN	EQU	0x11
BRI_UP	EQU	0x12
BRI_DN	EQU	0x13
SAT_UP	EQU	0x14
SAT_DN	EQU	0x15
BAS_UP	EQU	0x16
BAS_DN	EQU	0x17
TRE_UP	EQU	0x18
TRE_DN	EQU	0x19
BAL_RI	EQU	0x1A
BAL_LE	EQU	0x1B
CON_UP	EQU	0x1C
CON_DN	EQU	0x1D
HUE_UP	EQU	0x27
HUE_DN	EQU	0x1F
SHA_UP	EQU	0x4D
SHA_DN	EQU	0x4E
PHA_UP	EQU	0x48
PHA_DN	EQU	0x49
ADJUST	EQU	0x52
EXIT	EQU	0x53
ADDR	EQU	0x54
ASTRSK 	EQU	0x77
ENTER	EQU	0x57
F1	EQU	0x6B
PP	EQU	0x0E
F3	EQU	0x6D
F4	EQU	0x6E
F5	EQU	0x6F
CUR_UP	EQU	0x50
CUR_RI	EQU	0x56
CUR_DN	EQU	0x51
CUR_LE	EQU	0x55

; Definition of Functions on the Propeller clock
SEC_CL	    EQU	TRE_UP
TRotation   EQU	TRE_DN
TSecMode    EQU	F4
WDAY_UP     EQU BAL_RI
WDAY_DN     EQU BAL_LE
TStaticText EQU	TEXT
SET_SP      EQU	PAUSE
TWDay	    EQU	F3

SEC_UP		EQU	NUM_3
SEC_DN		EQU	NUM_6
MIN_UP		EQU	NUM_2
MIN_DN		EQU	NUM_5
HOUR_UP		EQU	NUM_1
HOUR_DN		EQU	NUM_4
DAY_UP		EQU	BRI_UP
DAY_DN		EQU	BRI_DN
MON_UP		EQU	SAT_UP
MON_DN		EQU	SAT_DN
YEAR_UP		EQU	CON_UP
YEAR_DN		EQU	CON_DN
INDEX_UP	EQU	VOL_UP
INDEX_DN	EQU	VOL_DN

BlueLine	EQU	PP
DigiTime	EQU	F1
DigiDate	EQU	MUTE
AnaTime		EQU	NUM_9
TTicks		EQU	NUM_0

DemoM		EQU	NUM_7	  ;Demo Mode
TextMode	EQU	NUM_8
